set addressVar to "%@"
set ccAddressVar to "%@"
set senderVar to "%@"
set subjectVar to "%@"
set contentVar to "%@"
set attachmentVar to (POSIX file "%@") as alias
set saveAsDrafts to (("%@" as integer) as boolean)
set singleJob to (("%@" as integer) as boolean)


--Go through contentVar and replace carriage returns (ascii 13)
--with the html <br> string
--This is used when the message is html formatted.
set fixedContentVar to ""
repeat with char in characters of contentVar
	set char_code to ASCII number of char
	if (char_code = 13) then
		set fixedContentVar to fixedContentVar & "<br>"
        else
		set fixedContentVar to fixedContentVar & char
	end if
end repeat

--Split up the to and cc addresses
set toAddressList to my splitAddresses(addressVar)
if length of ccAddressVar > 0 then
	set ccAddressList to my splitAddresses(ccAddressVar)
    else
	set ccAddressList to {}
end if


tell application "Microsoft Outlook"
if saveAsDrafts = true then
    set saveFolder to drafts
	else
    set saveFolder to mail folder "Temporary Items"
end if

--Use senderVar to determine which account to use
if (length of senderVar) > 0 then
    set allEmailAccounts to (get imap accounts) & (get pop accounts) & (get exchange accounts)
    set senderAccount to null
    set i to 1
    repeat while ((i is less than or equal to (count of allEmailAccounts)) and (senderAccount = null))
        set anAccount to item i of allEmailAccounts
        if (get email address of anAccount) = senderVar then
            set senderAccount to anAccount
        end if
        set i to i + 1
    end repeat
    if senderAccount = null then
        set senderAccount to default account
    end if
	else
    set senderAccount to default account
end if

set newMessage to make new outgoing message in saveFolder with properties {subject:subjectVar, account:senderAccount}

--If the message is html, put in the html version of the content.
--otherwise, put in just the content
if (has html of newMessage) then
    set content of newMessage to fixedContentVar
	else
    set content of newMessage to contentVar
end if



tell newMessage
make new attachment with properties {file:attachmentVar}
repeat with anAddress in toAddressList
    make new recipient with properties {email address:{name:"", address:anAddress}, type:to recipient type}
end repeat
--if there is a ccaddress, use it.
repeat with anAddress in ccAddressList
    make new recipient with properties {email address:{name:"", address:anAddress}, type:cc recipient type}
end repeat

end tell
if saveAsDrafts = false then
    send newMessage
	else
    if singleJob then
        open newMessage
        activate
    end if
end if
end tell


--Splits the addresses by commas
on splitAddresses(str)
	set tid to AppleScript's text item delimiters
	set newTID to ","
	
	try
		set AppleScript's text item delimiters to newTID
		set partsList to text items of str
		set AppleScript's text item delimiters to tid
        on error s number n
		set AppleScript's text item delimiters to tid
		error s number n
	end try
	
	return stripSpaces(partsList)
end splitAddresses

--strips spaces from before or after the address.
on stripSpaces(strList)
	set tid to AppleScript's text item delimiters
	set newTID to " "
	set partsList to {}
	
	try
		set AppleScript's text item delimiters to newTID
		repeat with str in strList
			repeat with shortString in text items of str
				if length of shortString > 0 then
					set end of partsList to (shortString as string)
				end if
			end repeat
			--set partsList to partsList & text items of str
		end repeat
		set AppleScript's text item delimiters to tid
        on error s number n
		set AppleScript's text item delimiters to tid
		error s number n
	end try
	
	return partsList
end stripSpaces